<?php
//   Backlink counter
//   (c) 2014-2025 Scriptol.com
//
//   Require one or more CSV file from Google Search Console.
//   The content must be a list of comma separated links each followed by two values.
//
//   This scripts build the list of your HTML or PHP pages from a local copy,
//   get the number of backlinks from the CSV file,
//   and build a table into an HTML file  to display the number of backlinks
//   for each of your pages.
//
//   If a page is not in the CSV file, the number of BL is assumed to be zero.
//
//   If several CSV files are provided, the difference between the first value
//   and the last value is displayed.
//
//   Path of the site and the CSV file must be stored in an INI file.
//   For example:   mysite.ini
//   then type: php backcount.php mysite.ini
//   Full instructions at:
//   https://www.scriptol.com/webmaster/backcount.php
include_once("path.php");
// Change flags below to filter files
$ignoreImage=true;
$pagesOnly=true;
$minSize=1024;
// End of flags section
$csv=array();
$cellnum=0;
$fh=0;
$csvname="";
$ininame="";
$siteurl="";
$sitecount="";
$filecount=0;
$dircount=0;
$sums=array();
$urlist=array();
// Change the lists below according to your site
$filesToExclude=array("header.php","top.php","sidebar.php","footer.php","bottom.php");
$extToExclude=array(".zip",".gz",".exe",".xml",".css",".js",".txt",".lib","wasm");
$imgExtensions=array(".jpg",".png",".gif",".jpeg",".bmp",".ico");
$outname="";
// Loading the ini file
function loadIni($name)
{
   $ini=array();
   if(!file_exists($name))
   {
      $oldname=$name;
      $name.=".ini";
      if(!file_exists($name))
      {
         die("Ini file '$oldname' or $name' not found.");
      }
   }
   $ini=file($name);
   foreach($ini as $line)
   {
      $line=trim($line);
      if(trim($line)==="")
      {
         continue;
      }
      if(substr($line,0,3)==="csv")
      {
         global $csvname;
         $csvname=substr($line,4);
      }
      if(substr($line,0,4)==="html")
      {
         global $outname;
         $outname=substr($line,5);
      }
   }
   return;
}

//  Load a CSV file, convert it into array
function loadCSV($fname)
{
   if(!file_exists($fname))
   {
      die("Error, $fname not found!");
   }
   global $urlist;
   $urlist=file($fname);
   array_shift($urlist);
   sort($urlist);
   return;
}

// Filter according to some extensions
function extFilter($url)
{
   $ext=Path::getExtension($url);
   global $ignoreImage;
   global $imgExtensions;
   if($ignoreImage&&(in_array(strtolower($ext),$imgExtensions)))
   {
      return true;
   }
   global $pagesOnly;
   if($pagesOnly)
   {
      global $extToExclude;
      if(in_array(strtolower($ext),$extToExclude))
      {
         return true;
      }
   }
   return false;
}

// Add a line in the HTML file
function tohtml($str)
{
   global $fh;
   fwrite($fh,$str);
   return;
}

function main($argnum,$argv)
{
   if($argnum<2)
   {
      global $ininame;
            echo "Type the name of an ini file or press Enter : ";
      $fp=fopen("php://stdin","r");
      $ininame=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   else
   {
      global $ininame;
      $ininame=$argv[1];
   }
   global $ininame;
   if($ininame==="")
   {
      $ininame="backcount.ini";
   }
   echo "Loading configuration file", " ", $ininame, "\n";
   loadIni($ininame);
   global $csvname;
   if($csvname==="")
   {
      die("No CSV file found.");
   }
   loadCSV($csvname);
   global $outname;
   if($outname==="")
   {
      $outname=Path::changeExt($ininame,".html");
   }
   echo "Generating $outname", "\n";
   $thedir="";
   $latest="";
   $thefile="";
   global $fh;
   $fh=fopen($outname,"w");

   tohtml("<!DOCTYPE html\n");
   tohtml("<html>\n");
   tohtml("<head>\n");
   tohtml("<link type='text/css' href='backcount.css' rel='stylesheet'>\n");
   tohtml("</head>\n");
   tohtml("<body>\n");
   global $siteurl;
   global $sitecount;
   tohtml("<h1>".$siteurl." ".$sitecount."</h1>\n");
   $total=0;
   $totalsrc=0;
   tohtml("<table>\n<tr><td><b><u>Page</u></b></td><td><b><u>Links</u></b></td></td><td><b><u>Sources</u></b></td>");
   global $urlist;
   foreach($urlist as $csvline)
   {
      tohtml("<tr>");
      $data=explode(",",$csvline);
      $url=$data[0];
      $ctr=intVal(intval($data[1]));
      $total+=$ctr;
      $ctrsrc=intVal(intval($data[2]));
      $totalsrc+=$ctrsrc;
      if(substr($url,-1)==="/")
      {
         tohtml("<td><br><b>".$url."</b></td>");
         $thedir=$url;
      }
      else
      {
         $_I1=Path::splitFile($url);
         $thedir=reset($_I1);
         $thefile=next($_I1);
         if($thedir!=$latest)
         {
            tohtml("<td><br>".$url."</td>");
         }
         else
         {
            tohtml("<td>".$url."</td>");
         }
      }
      $latest=$thedir;
      tohtml("<td>".$data[1]."</td><td>".$data[2]."</td>");
      tohtml("</tr>\n");
   }
   tohtml("</table></div>");
   global $urlist;
   tohtml("<div><p>".strval(count($urlist))." files.");
   tohtml("<p>Total backlinks ".strval($total)."<br />");
   tohtml("Different sources ".strval($totalsrc)."</p></div>");
   tohtml("</body></html>");
   fclose($fh);
   echo "\n";
   echo "Total backlinks from different sites: ",$totalsrc;
   echo "\n";
   echo "$outname created.", "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
