
#   Backlink counter
#   (c) 2014-2025 Scriptol.com
#   
#   Require one or more CSV file from Google Search Console.
#   The content must be a list of comma separated links each followed by two values.
#   
#   This scripts build the list of your HTML or PHP pages from a local copy,
#   get the number of backlinks from the CSV file, 
#   and build a table into an HTML file  to display the number of backlinks
#   for each of your pages.
#   
#   If a page is not in the CSV file, the number of BL is assumed to be zero.
#   
#   If several CSV files are provided, the difference between the first value
#   and the last value is displayed.  
#  
#   Path of the site and the CSV file must be stored in an INI file.
#   For example:   mysite.ini
#   then type: php backcount.php mysite.ini
#   Full instructions at:
#   https://www.scriptol.com/webmaster/backcount.php

include "path.sol"

# Change flags below to filter files

boolean ignoreImage = true       // assign false to include images
boolean pagesOnly = true         // assign false or change the list of extensions to add others
int minSize = 1024               // assign 0 to suppress the minimum size for a file

# End of flags section

array csv   // list of csv filenames   
int cellnum
file fh
text csvname
text ininame
text siteurl          // Domain 
text sitecount        // Backlinks to the home page   
int filecount = 0
int dircount = 0
array sums
array urlist           // list of urls

# Change the lists below according to your site

array filesToExclude = [ "header.php", "top.php", "sidebar.php", "footer.php", "bottom.php" ]
      
array extToExclude = [".zip", ".gz", ".exe", ".xml", ".css", ".js", ".txt", ".lib", "wasm" ]
  
array imgExtensions = [ ".jpg", ".png", ".gif", ".jpeg", ".bmp", ".ico" ]    

text outname = ""

# Loading the ini file

void loadIni(text name)
  array ini
  if not file_exists(name) 
    text oldname = name
    name + ".ini"
    if not file_exists(name) let die("Ini file '$oldname' or $name' not found.")
  /if  
  ini.load(name)

  for text line in ini
    line = line.trim()
    if line.trim() = "" continue   
    if line[0 .. 2] = "csv"
      csvname = line[4 ..]
    /if
    if line[0 .. 3] = "html"
      outname = line[5 ..]
    /if  
  /for
return        


#  Load a CSV file, convert it into array

void loadCSV(text fname)
    if not file_exists(fname) 
      die("Error, $fname not found!")
    /if
    urlist.load(fname)
    urlist.shift()    // remove header
    urlist.sort()
return    


# Filter according to some extensions

boolean extFilter(text url)
  text ext = Path.getExtension(url)
  if ignoreImage and (ext.lower() in imgExtensions) return true
  if pagesOnly 
    if ext.lower() in extToExclude return true
  /if  
return false  


# Add a line in the HTML file

void tohtml(text str)
  fh.write(str)
return  

int main(int argnum, array argv)

  if argnum <  2
    input "Type the name of an ini file or press Enter : ", ininame
	else
    ininame = argv[1]
  /if	

  if ininame = "" let ininame = "backcount.ini"

  print "Loading configuration file", ininame
  loadIni(ininame)

  if csvname = "" 
    die( "No CSV file found." )
  /if  
  loadCSV(csvname)

  // if no html output filename, use the ini filename with html extension instead

  if outname = ""
    outname = Path.changeExt(ininame, ".html")
  /if  

  print "Generating $outname"

  text thedir
  text latest
  text thefile

  fh = fopen(outname, "w")

  tohtml("<!DOCTYPE html\n")
  tohtml("<html>\n")
  tohtml("<head>\n")
  tohtml("<link type='text/css' href='backcount.css' rel='stylesheet'>\n")
  tohtml("</head>\n")
  tohtml("<body>\n")
  tohtml("<h1>"+siteurl+" "+sitecount+"</h1>\n")

  int total = 0
  int totalsrc = 0
  tohtml("<table>\n<tr><td><b><u>Page</u></b></td><td><b><u>Links</u></b></td></td><td><b><u>Sources</u></b></td>")
  for text csvline in urlist
    tohtml("<tr>")
    array data = csvline.split(",")
    text url = data[0]
    int ctr = intval(data[1])
    total + ctr
    int ctrsrc = intval(data[2])
    totalsrc + ctrsrc
    if url[-1 ..] = "/"
      tohtml("<td><br><b>" + url + "</b></td>")
      thedir = url
    else
      thedir, thefile = Path.splitFile(url)
      if thedir <> latest
        tohtml("<td><br>" + url + "</td>")
      else
        tohtml("<td>" + url + "</td>")
      /if
    /if
    latest = thedir
    tohtml("<td>" + data[1] + "</td><td>" + data[2]+"</td>")  
    tohtml("</tr>\n");
  /for
  
  tohtml("</table></div>")   

  tohtml("<div><p>"+strval(urlist.size())+" files.")
  tohtml("<p>Total backlinks " + strval(total) + "<br />");
  tohtml("Different sources " + strval(totalsrc) + "</p></div>")

  tohtml("</body></html>")    

  fh.close() 

  print
  echo  "Total backlinks from different sites: ", totalsrc
  print
  print "$outname created."  

return 0

main($argc, $argv)
