# Composite 
# (c) 2026 Scriptol.com/ Scriptol.fr. By Denis Sureau
# Free under the GNU GPL 2 License.
# Requires the PHP 8 interpreter.
# Compiling the sources requires the Scriptol 2 to PHP compiler.
#
# The composter updates a website from a local directory.
# Links in the pages are checked for broken or redirected urls.

include "path.sol"
include "ftp.sol"
include "linkcheck.sol"

bool CHECKMODE = false   // True for virtual operations
bool BACKUP = true    // True to work with a backup directory
bool ANYFILES = false  // restoring the site and uploading the full content
bool ANYWEXT = false // update all file with this extension
bool TOUCHFLAG = true  // server of back supports the touch function (accelarator)
bool CONTFLAG = false  // compare by content, not by time
bool SKIPPED = false   // display skipped files
bool NOLOCAL = false   // skip executing PHP locally.
bool MAPFLAG = false   // process site map or not
bool HTACCESS = true  // if true replace .htaccess file too
text REMOTEEXT = ""    // for the generated file
array TOPROCESS = ["html"] // for the original files, may be changed or extended
bool CHANGEEXT = false  // replace the extension if true

int days = 0        // Number of past days to handle for updating 
text server = "" 	// The ftp address
text user = ""		// login
text pass = ""		// password
array params = []
text backdir = ""   // backup directory or drive
text temporary = "temporary-file.000.tmp"
int remlength = 0   // number of chars of the folder on the host
array extToUpdate = []  // extension of files to update without comparison

int connection		// handler
int counter         // Number of files uploaded
int falsecounter    // Number of files to copy
int problem


void usage()
	print
	print "Composite 1.0 - (c) 2026 Scriptol.com/Scriptol.fr"
	print "-------------------------------------------------"
	print "Syntax:"
	print "  php composite.php [options] parameters"
	print "Options:"
	print "  -t test, display only, send nothing to the server."
	print "  -v verbose, display more infos."
	print "  -q quiet, display nothing."	
	print "  -a[ext] update all files. Or file with the given extension."
	print "  -oext replace default html extension of files to process or add one."
	print "  -rext extension for generated file (default unchanged)."
	print "  -u send all files unchanged, do not execute locally."
	print "  -s speed, do not check links."
	print "Parameters:"
	print "  -ppassword."
	print "  -llogin."
	print "  directory: local directory where pages are stored."
	print "  -fftpadr remote site adr in the form ftp.example.com or IP."
	print "  -bbackup, defining a backup directory for comparison."  
	print "  -ddirectory remote directory."
	print "  -w website url."
	exit(0)
return

boolean syncConnect()
	connection = ftp_connect(server)
	if ftp_login(connection, user, pass) = true
		print "Connected on $server as $user"
		if ftp_pasv(connection, true) = true
		    print "Passive mode turned on"
		else
            print "Enable to set passive mode"
        /if    
		return true
	else	
		print "Enable to log as $user on $server"
	/if
return false

void syncDisconnect()
	ftp_close(connection)
return

// size of a remote file

int syncSize(text fname)
return ftp_size(connection, fname)	

int syncTime(text fname) 
return ftp_mdtm(connection, fname)


boolean filecompare(text a, text b)
	array x, y
	x.load(a)
	y.load(b)
return x = y	


// Check the presence of the external device or the existence of the directory
// for the backup.

void backError(text b)
  print "Can't write on backup $b, check device or path and try again..."
  exit(0)
return  
  

void checkBackup(text bpath)
  text tempfile = Path.merge(bpath, "ftpsynxyz.$$$")
  file f 
  f.open(tempfile, "w")
  error ? backError(bpath)
  int saved = f.write("ftp synchro")
  f.close()

  if saved = 0
    backError(bpath)
  else
    if CONTFLAG
      print "Files compared by content"
      TOUCHFLAG = false
      return 
    /if
    TOUCHFLAG = touch(convertUnix(tempfile), time())
    unlink(tempfile)
    if not QUIET 
      if TOUCHFLAG 
        print "Files compared by time"
      else
        print "Touch failed, files compared by contents"
      /if    
    /if  
  /if
return

void checkRemote(text rpath)
  TOUCHFLAG = touch(rpath, time())
return         

// For the URL, full site url + remote path - domaine 

text buildURL(text rempath)
    int rd = rdlength      // remove domain from remote path
    text url = rempath[ rd .. ]
    url = Path.merge(website, url)
return url


// send a file

void filecopy(text src, text rmt, text loc, bool composeflag, text locdir)

	if CHECKMODE = true
		print "Will upload $src on the host in " + rmt
		text rmtpath =  rmt[remlength ..]
		text url = Path.merge(website, rmtpath)
		print "And will update ", url 
		falsecounter + 1
		return
	/if
	
	if QUIET  = false
		echo "Uploading $src "
        print "to $rmt"
	/if

    if CHECKLINKS let linkCheckerDiffered(src)   
	text root = ""
	int occur = substr_count(locdir, "/")
	occur + substr_count(locdir, "\\")

	if occur > 1
		root = dirname(locdir)
	else
		root = locdir
	/if	

	bool putres 
	if composeflag = true
		text content 
		int reterr
		~~
		exec("php $src $root $locdir", $content, $reterr);
		~~
		file tempfile = fopen('php://temp', 'r+')
		fwrite(tempfile, implode("\n", content));
		rewind(tempfile); 
		putres = ftp_fput(connection, rmt, tempfile, $(FTP_BINARY))
    else
    	putres = ftp_put(connection, rmt, src, $(FTP_BINARY))
	/if
	
	if putres = true
		counter + 1
		if BACKUP = true  
            copy(src, loc)
            if loc = nil return     // No backup file
            boolean b = @touch(convertUnix(loc), filemtime(src))  // set same date and time now
            if not b            
                print "Failed to set date and time for ", convertUnix(loc)
            /if
        /if
		if VERBOSE
			text rmtpath =  rmt[remlength ..]
			text url = Path.merge(website, rmtpath)
			print "Updated url :", url 
		/if
	else
		print "Error, $src not uploaded"
	/if	
return


boolean remoteIdentical(text lfile, text rfile)
  if DEBUG = true print "Comparing $lfile and remote $rfile"
	if @ftp_get(connection, temporary, rfile, $(FTP_BINARY)) != true return false
	array x, y
	x.load(lfile)
	y.load(temporary)
return x = y


// compare file with backup

boolean backupIdentical(text locfile, text bakfile)
  array x, y
  if DEBUG = true print "Comparing $locfile and local $bakfile"
  if not file_exists(bakfile) return false
	if filesize(locfile) <> filesize(bakfile) return false
	if TOUCHFLAG
	 int a = filemtime(locfile)
	 int b = filemtime(bakfile)
	 if a = b return true
	/if
	x.load(locfile)
    y.load(bakfile)
return x = y


// compare date of file with number of days 

boolean dateCompare(int loctime, int numdays)
  numdays + 1
  int nt = time() - (86400 * numdays)
return loctime >= nt 


// synchronize

void synchro(text locdir, text bdir, text hostdir)

	array content = scandir(locdir)
	text bckname, rmtname
	boolean returned
	
	if hostdir <> nil
	  if VERBOSE 
      echo "Creating $hostdir if needed"
      if BACKUP echo ", and $bdir"
      print
    /if      
	  
    if not CHECKMODE 
      @ftp_mkdir(connection, hostdir)
      if BACKUP = true
        if not file_exists(bdir) let @mkdir(bdir)
      /if 
    /if
	/if	
	
	if content.empty() return
	
	// processing files
	
	for text basename in content
		text srcname
        if basename[0] = "/"
   	        srcname = Path.merge(website, basename) 
        else    
   	        srcname = Path.merge(locdir, basename)
		/if  
	
		if filetype(srcname) = "file"
			boolean composeflag
			rmtname = Path.merge(hostdir, basename)
			text ext = pathinfo(basename, $(PATHINFO_EXTENSION));
			composeflag = false

			if ext in TOPROCESS let composeflag = true
			if NOLOCAL let composeflag = false
			
			if CHANGEEXT and composeflag
				int pos = strrpos(rmtname, ".", 0)
				if pos > 0
					rmtname = substr_replace(rmtname, REMOTEEXT, pos)
				/if	
			/if

            // .htaccess and such files ignored at request
                     
            if basename[0] = "." and not HTACCESS    
                if not QUIET print basename, "skipped"
                problem + 1
                continue 
            /if
			
            // compare with backup and upload if different
         
           if BACKUP = true 
                bckname = Path.merge(bdir, basename)
				returned = false
				if not ANYFILES and not ANYWEXT
                	returned = backupIdentical(srcname, bckname)
				/if		
				if ANYWEXT
					if ext in extToUpdate = false let returned = true
				/if			
                if not returned
		          filecopy(srcname, rmtname, bckname, composeflag, locdir)
		        else
                  if SKIPPED print "  Skipped ", srcname    
            	/if
                continue
            else
            	// compare with remote file and upload if different
            	returned = remoteIdentical(srcname, rmtname)
            	if not returned
                	filecopy(srcname, rmtname, "", composeflag, locdir)
            	else
                	if SKIPPED print "  Skipped ", srcname 
				/if	   
	       /if
		/if
	/for

	// processing subdirs
	
	for text basename in content
	    if basename[0] = '.' continue
		text srcname = Path.merge(locdir, basename)	
		if filetype(srcname) = "dir"
			synchro(srcname, Path.merge(bdir, basename), Path.merge(hostdir, basename))
		/if
	/for	

return

boolean readLogin()
	array loglist
	loglist.load("ftpsync.login")
	for text line in loglist
		if server in line
			array data  = line.split(" ")
			user = data[1]
			pass = data[2]
			return true
		/if
	/for	
return false	


// Parsing command line parameters
// Stored into an array to overcome problems with PHP's global variables

void processCommand(int argnum, array arguments)

	if argnum < 2
		usage()
	/if	

	for text param in arguments
		text value
		text opt

		if param.length() > 1
			opt = param[..1]
			if opt[0] = "-" and param.length() > 2
				value = param[2..]
			/if
		else
			usage()
		/if	

		if opt = "-t" 
			CHECKMODE = true
			continue
		/if	

		if opt = "-a" 
			if value.length() = 0
				ANYFILES = true
			else
				ANYWEXT = true
				extToUpdate.push(value)
			/if	
			continue
		/if	

		if opt = "-r"
			if value.length() > 0
				REMOTEEXT = value
				CHANGEEXT = true				
				if value[0] != "."
					REMOTEEXT = "." + value
				/if
			else	
				die("-e must be followed by an extension name")
			/if	
			continue
		/if

		if opt = "-o"
			if value.length() = 0 let die("-o must be followed by an extension name")	
			if TOPROCESS.size() = 1
				TOPROCESS[0] = value
			else
				TOPROCESS.push(value)
			/if	
			continue
		/if

		if opt = "-v" 
			VERBOSE = true
			continue
		/if
        
       	if opt = "-k" 
			SKIPPED = true
			continue
		/if		

		if opt = "-q" 
			QUIET = true
			continue
		/if	

		if opt = "-~" 
			DEBUG = true
			continue
		/if

		if opt = "-s"
			CHECKLINKS = false
			continue
		/if
    
        if opt = "-c"
            CONTFLAG = true
            continue
        /if  
        
		if opt = "-u"
            NOLOCAL = true 
			continue
		/if		

		if opt = "-p"
			pass = value
			if pass = nil let die("-p must be followed by the password.")
			continue
		/if	

		if opt = "-l"
			user = value
			if user = nil let die("-l must be followed by the login.")			
			continue
		/if

		if opt = "-f"
			server = value
			if server = nil let die("-f must be followed by the ftp address.")			
			continue
		/if

		if opt = "-w"
			website = value
			if website = nil let die("-w must be followed by the site url.")			
			continue
		/if

		if opt = "-d" 
			remotedir = value
			if remotedir = nil let die("-d requires a sub-directory.")
			remlength = remotedir.length()
			continue
		/if	
    	
		if opt = "-b"
			backdir = value
			if backdir = nil let die("-b requires a directory.")	
			BACKUP = true
			continue
		/if
    	
		if param[ .. 3] = "ftp."
			server = param
			continue
		/if	
		
		if opt = "-h" 
			HTACCESS = true
			continue
		/if	

		if param[0] = "-" 
        	print "Unknown command $param"  
        	usage()
    	/if   
		
		if source = nil
			source = param
			continue
		/if	
		
		print "Unknown command $param"
    
    usage()
		
	/for


  if BACKUP = true let checkBackup(backdir)

	if server = nil input "FTP location: ",  server
	if server = nil let exit(0)

	if source = nil input "Directory to send: ",  source
	if source = nil let exit(0)

	if user = nil input "Login: ",  user
	if user = nil let exit(0)

	if pass = nil input "Password: ", pass	
	if pass = nil let exit(0)

return


int main(int argc, array argv)

	array x = argv[ 1 .. ]
	server = "" 
	processCommand(argc, x)

    problem = 0
    
    // Check base URL for canonical tag
    if website = nil
		die("This program requires the url of the website to work.")
    else
        if not hasProtocol(website)
            website = "https://" + website
        /if
    /if  
    
    if not QUIET
        if VERBOSE = true print "Verbose mode enabled"
        if DEBUG = true print "Debug mode enabled"
   
		print "Source directory: ", source
		print "Website: ", website
        print "Remote directory: ", remotedir
        if BACKUP = true print "Backup location: ", backdir
        if ANYFILES = true print "All fille will be uploaded regardless of changes."
		if ANYWEXT = true print "All files with selected extension will be updated."
		print "Extensions of files to process: ", implode(" ", TOPROCESS)
		text extstr = "unchanged"
		if REMOTEEXT != "" let extstr = REMOTEEXT
		if CHANGEEXT = true print "Remote extension : $extstr"
        if CHECKLINKS 
            print "Link checker active."
            if function_exists("curl_init") 
                print "Curl active."
             else
                print "Curl not supported, enable it in php.ini."
            /if    
        /if  
       
    /if

	syncConnect()
	
	print "Synchronizing $source on $server"
	synchro(source, backdir, remotedir)		// starting at root or given remote path
	
	syncDisconnect()
	
	if QUIET return 0
	
	echo counter, " file", plural(counter), " copied"
	if CHECKMODE
        if falsecounter > 0 
            echo ", ", falsecounter, " file", plural(falsecounter)," to update"
        else
            echo ", nothing to update"
        /if
    /if      
	print "."
	if problem > 0 print "$problem file" + plural(problem) , "skipped."
	
    if MAPFLAG and counter > 0
        updateMap()
    /if 

	if CHECKLINKS and counter > 0
       differedCheck()
       dispBroken()
    /if  
    
	if file_exists(temporary) let unlink(temporary)
	print "Done." 
	
return 0

main($argc, $argv)
