<?php
// Update your website to HTTPS
// (c) 2017-2023 Scriptol.com
// Free under the MIT License.
// Requires the PHP 7 interpreter.
// Works on a local copy of your site.
// Searches for http links to the domain given in parameter
// and replaces http by https.
// Once all pages updated, you have to put them online
// with a script such as PHP FTP Synchronizer.
//
include_once("scriptol-path.php");
$website="";
$pcounter=0;
$dcounter=0;
$mcounter=0;
// Add your extension if not in list
$extensions=array(".html",".htm",".asp",".php",".xml");
function usage()
{
   echo "\n";
   echo "HTTP to HTTPS converter - (c) 2017-2023 Scriptol.com", "\n";
   echo "Usage:", "\n";
   echo "Go to the root of the local copy of the site and type:", "\n";
   echo "  php tohttps.php domain-name", "\n";
   echo "The name of the domain or subdomain, www.example.com or example.com, is the parameter.", "\n";
   echo "The protocol http:// will be added to retrieve the links to update to https.", "\n";
   exit(0);
   return;
}

$HTTPURL="";
$HTTPSURL="";
$count=0;
// Utilities
function hasProtocol($url)
{
   if(strpos($url,"://")!=false)
   {
      return true;
   }
   return false;
}

// Scan page
function update($fpath)
{
   $str=file_get_contents($fpath);
   global $HTTPURL;
   global $HTTPSURL;
   global $count;
   $str=str_replace($HTTPURL,$HTTPSURL,$str,$count);
   if($count>0)
   {
      $ret=file_put_contents($fpath,$str);
      if($ret!=false)
      {
         echo $count, " ", "changes in", " ", $fpath, "\n";
         if($count>0)
         {
            global $mcounter;
            $mcounter+=$count;
         }
      }
      else
      {
         echo "Enable to write in", " ", $fpath, "\n";
      }
   }
   return;
}

// Scan directory
function convert($locdir)
{
   echo $locdir, "\n";
   echo str_repeat("-",strlen($locdir)), "\n";
   $content=scandir($locdir);
   $src="";
   $returned=0;
   if(empty($content))
   {
      return;
   }
   foreach($content as $name)
   {
      if($name[0]===".")
      {
         continue;
      }
      $e=Path::getExtension($name);
      global $extensions;
      if(!(in_array($e,$extensions)))
      {
         continue;
      }
      $name=Path::merge($locdir,$name);
      if(filetype($name)==="file")
      {
         update($name);
         global $pcounter;
         $pcounter+=1;
      }
   }
   foreach($content as $name)
   {
      if($name[0]==='.')
      {
         continue;
      }
      $name=Path::merge($locdir,$name);
      if(filetype($name)==="dir")
      {
         convert($name);
         global $dcounter;
         $dcounter+=1;
      }
   }
   return;
}

// Parsing command line parameters
function processCommand($argnum,$arguments)
{
   if($argnum<2)
   {
      usage();
   }
   foreach($arguments as $param)
   {
      global $website;
      if($website==="")
      {
         $website=$param;
         continue;
      }
      echo "Unknown command $param", "\n";
      usage();
   }
   global $website;
   if($website==="")
   {
            echo "Domain name: ";
      $fp=fopen("php://stdin","r");
      $website=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($website==="")
   {
      exit(0);
   }
   return;
}

// Main function
function main($argc,$argv)
{
   $x=array_slice($argv,1);
   processCommand($argc,$x);
   global $website;
   if(!hasProtocol($website))
   {
      global $HTTPURL;
      $HTTPURL="http://".$website;
      global $HTTPSURL;
      $HTTPSURL="https://".$website;
   }
   else
   {
      die("Enter domain name without protocol (no http).");
   }
   echo "Replacing $HTTPURL by $HTTPSURL", "\n";
   convert(getcwd());
   global $pcounter;
   global $dcounter;
   echo $pcounter," file",($pcounter>1?"s":"")," scanned in ",$dcounter," dir",($dcounter>1?"s":""),", ";
   global $mcounter;
   echo $mcounter," URL",($mcounter>1?"s":"")," converted.";
   echo "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
