# Update your website to HTTPS
# (c) 2017-2023 Scriptol.com
# Free under the MIT License.
# Requires the PHP 7 interpreter.

# Works on a local copy of your site.
# Searches for http links to the domain given in parameter
# and replaces http by https.
# Once all pages updated, you have to put them online
# with a script such as PHP FTP Synchronizer.
#

include "scriptol-path.sol"

text website = "" 	 // The ftp address
int pcounter = 0     // Number of pages
int dcounter = 0     // Number of directories
int mcounter = 0     // Number of pages modified

# Add your extension if not in list

array extensions = [".html", ".htm", ".asp", ".php", ".xml" ]   

void usage()
	print
	print "HTTP to HTTPS converter - (c) 2017-2023 Scriptol.com"
	print "Usage:"
	print "Go to the root of the local copy of the site and type:"
	print "  php tohttps.php domain-name"
	print "The name of the domain or subdomain, www.example.com or example.com, is the parameter."
	print "The protocol http:// will be added to retrieve the links to update to https."
	exit(0)
return


text HTTPURL
text HTTPSURL
int count

# Utilities

bool hasProtocol(text url)
    if url.find("://") != nil return true
return false    

# Scan page

void update(text fpath)
    text str = file_get_contents(fpath)
    str = str_replace(HTTPURL, HTTPSURL, str, count)
    if count > 0
        var ret = file_put_contents(fpath, str)
        if ret <> false
            print count, "changes in", fpath
            if count > 0 ? mcounter + count
        else
            print "Enable to write in", fpath
        /if    
    /if
return    

# Scan directory

void convert(text locdir)

	print locdir
	print "-".dup(locdir.length())

	array content = scandir(locdir)
	text src
	boolean returned
	if content.empty() return
	
	// processing files
	
	for text name in content
	    if name[0] = "." continue
	    text e = Path.getExtension(name)
	    if not (e in extensions) continue
        name = Path.merge(locdir, name) 
		if filetype(name) = "file"
            update(name)
            pcounter + 1
		/if
	/for

	// processing subdirs
	
	for text name in content
	    if name[0] = '.' continue
		name = Path.merge(locdir, name)	
		if filetype(name) = "dir"
			convert(name)
			dcounter + 1
		/if
	/for	

return


# Parsing command line parameters

void processCommand(int argnum, array arguments)
	if argnum <  2 ? usage()

	for text param in arguments
		if website = nil
			website = param
			continue
		/if	
		print "Unknown command $param"
        usage()
	/for

	if website = nil input "Domain name: ",  website
	if website = nil let exit(0)
return

# Main function

int main(int argc, array argv)

	array x = argv[ 1 .. ]
	processCommand(argc, x)

    if not hasProtocol(website)
        HTTPURL = "http://" + website
        HTTPSURL = "https://" + website
    else
       die("Enter domain name without protocol (no http).")
    /if  
    
    print "Replacing $HTTPURL by $HTTPSURL"
	convert(getcwd())

	echo pcounter, " file", plural(pcounter), " scanned in ",  dcounter, " dir", plural(dcounter), ", "
	echo mcounter, " URL", plural(mcounter), " converted."
	print

return 0

main($argc, $argv)
