/* Generated by Scriptol */

//
// LinkCheck - Scriptol Library
// https:
// Licence: LPGL
// Check an HTML page for broken links
//
// (c) 2008-2025 by Denis Sureau
eval(fs.readFileSync(__dirname + '/path.js')+'');
eval(fs.readFileSync(__dirname + '/utils.js')+'');
var DEBUG=false;

var website="";

var domain="";

var source="";

var root="";

var broken=["Links report:"];

var pagesToCheck=[];

var BROCOUNT=0;

var CHECKS=0;

var CHECKOK=0;

var CHECKBAD=0;

var extensions=[".html",".php",".htm",".php5",".asp",".shtml",".dhtml",".jsp",".xhtml",".stm"];

var PAGES={};

function hasProtocol(theurl)
{
   var lowname=scriptol.ltrim(theurl).toLowerCase();

   if(lowname.slice(0,7)==="http://") {
      return true;
   }
   if(lowname.slice(0,6)==="ftp://") {
      return true;
   }
   if(lowname.slice(0,8)==="https://") {
      return true;
   }
   return false;
}

function isHTML(name)
{
   var ext=Path.getExtension(name);

   if((extensions.indexOf(ext)!=-1)) {
      return true;
   }
   return false;
}

function dispLinksChecks()
{
   for(var filename in PAGES) {
      var plist=PAGES[filename];
      console.log(filename);
      console.log(scriptol.dup("-",filename.length));
      for(var p in plist) {
         p=String(plist[p]);
         console.log(p);
      }
   }
   return;
}

var links=[];

function linkchecker(filename)
{
   var hostroot="";

   var content="";

   var dnl=[];

   var link="";

   if(!isHTML(filename)) {
      return;
   }
   filename=convertUnix(filename);
   if(VERBOSE) {
      console.log("Scanning "+filename);
   }
   $_I1=Path.splitFile(filename);
   hostroot=$_I1[0];
   link=$_I1[1];
   hostroot=hostroot=hostroot.replace(root,website);
   content=fs.readFileSync(filename,"utf-8");
   if(content==="") {
      if(VERBOSE) {
         console.log(filename+" empty.");
      }
      return;
   }
   dnl=retrieveLinks(content);
   if(VERBOSE) {
      console.log(dnl.length+' '+" links in "+' '+filename);
   }
   if(dnl.length===0) {
      return;
   }
   for(var href in dnl) {
      href=String(dnl[href]);
      var original=href;

      if(href.charAt(0)==="#") {
         continue;
      }
      if(href.charAt(0)==="/") {
         if(href.charAt(1)==="/") {
            continue;
         }
         href=Path.merge(website,href);
      }
      var p=href.indexOf("#");

      if(p!=0) {
         href=href.slice(0,p);
      }
      if(!hasProtocol(href)) {
         if(href.length>11) {
            if(href.slice(0,11)==="javascript:") {
               if(DEBUG) {
                  console.log("Skipped javascript.");
               }
               continue;
            }
         }
         if(href.length>7) {
            if(href.slice(0,7)==="mailto:") {
               if(DEBUG) {
                  console.log("Skipped mailto.");
               }
               continue;
            }
         }
         href=Path.merge(hostroot,href);
      }
      if(href.length<8) {
         continue;
      }
      if(href.slice(0,4).toLowerCase()!="http") {
         continue;
      }
      links.push([href,filename]);
   }
   return;
}

async function differedCheck(FilesArray)
{
   links=[];
   var n=FilesArray.length;

   var s=(n>1?"s":"");

   console.log("Found "+n+" page"+s+"...");
   root=convertUnix(source);
   for(var t in FilesArray) {
      t=String(FilesArray[t]);
      linkchecker(t);
   }
   var size=links.length;

   s=(size>1?"s":"");
   console.log(size+' '+"link"+s+" to check.");
   if(size===0) {
      return;
   }
   for(var entry in links) {
      entry=links[entry];
      try {
                  await checkLink(entry[0],entry[1]);
      }
      catch(e) {
                  console.log(+"{entry[0]}, failed to access");
      }
   }
   beforeExit();
   return;
}



/* End */
