/**
	PHP Implementation of DOM official
	Fully compatible with PHP, requires Scriptol PHP
	This interface (c) 2007 Denis Sureau - Mozilla 1.1 Licence.
	
	This is not compatible with the current dom library of Scriptol C++,
	but will be implemented further as C++ extension.
*/

extern

class DOMComment
/class

class DOMText
    text wholeText
	void DOMText(cstring = "")
	DOMText splitText()
/class

class DOMNode
	text nodeValue         // the content
	text nodeName
	text textContent
	DOMNode firstChild
	DOMNode lastChild
	DOMNode previousSibling
	DOMNode nextSibling
	
	boolean hasChildNodes()
	boolean hasAttributes()
	DOMNode appendChild(DOMNode)
	DOMNode removeChild(DOMNode)
	DOMNode replaceChild(DOMNode)
	DOMNode insertBefore(DOMNode, DOMNode)
/class

class DOMNodeList
	DOMNode item(integer)
	int length             // the number of elements
/class

class DOMElement is DOMNode
	cstring textContent
	cstring tagName
    
	void DOMElement(cstring)
	boolean hasAttribute(cstring)
	cstring getAttribute(cstring)
	boolean setAttribute(cstring, cstring)
	void setIdAttribute(cstring, boolean)
	boolean removeAttribute(cstring)
	DOMNodeList getElementsByTagName(cstring)
/class


class DOMDocument

  cstring encoding

  void DOMDocument(cstring = "", cstring="")
	boolean loadHTMLFile(cstring)	// Load a HTML file
	boolean loadHTML(cstring)		// Create HTML from the raw content of a string
	boolean load(cstring)		// Load an XML file
	boolean loadXML(cstring)		// Convert a string into XML. 
	var save(cstring)			// Save HTML or XML into a file.
	cstring saveHTML(cstring = null)	// Return a HTML document (save to string)
	cstring saveXML(cstring = null)	// Return an XML document (save to string)
	
	DOMElement getElementById(cstring)
	DOMNodeList getElementsByTagName(cstring)
	
	boolean validate()		// Check using the DTD of the document
	
	DOMText createTextNode (cstring)
	DOMNode appendChild(DOMNode)
	DOMElement createElement(cstring)	// Create an orphan DOMElement, use appendChild
	DOMComment createComment(cstring)	// Create an orphan DOMComment

/class

/extern


