/*
   FTP Check
   (c) 2016 Denis Sureau at Scriptol.com
   License: MIT
   To be used freely provided this copyright notice is included
*/

var JSFtp = require("jsftp")

var OPTIONS=[];
var server="";
var user="";
var pass="";
var filename=""

function processCommand(argnum,args)
{
   var opt="";
   if(argnum<2) {
      usage();
   }
   
   for(var param in args) {
      param=String(args[param]);
      if(param.length>1) {
         opt=param.slice(0,2);
      }      
      else {
         usage();
      }

      if(opt==="-p") {
         pass=param.slice(2);
         if(pass==="") {
            scriptol.die("-p must be followed by the password.");
         }
         continue;
      }
      if(opt==="-l") {
         user=param.slice(2);
         if(user==="") {
            scriptol.die("-l must be followed by the login.");
         }
         continue;
      }
      if(opt==="-f") {
         server=param.slice(2);
         if(server==="") {
            scriptol.die("-f must be followed by the ftp address.");
         }
         continue;
      }
 
      if(param.slice(0,4)==="ftp.") {
         server=param;
         continue;
      }
      if(param.charAt(0)==="-") {
         console.log("Unknown command "+param);
         usage();
      }
      if(filename==="" || filename==undefined) {
         filename=param;
         continue;
      }
      console.log("Unknown command "+param);
      usage();
   }

   if(server==="") {
      process.stdout.write("FTP location: ");
      server=fs.readSync(process.stdin.fd, 100, 0, 'utf8').shift().trim();
      process.stdin.pause();
   }
   if(server==="") {
      process.exit(0);
   }
   if(filename==="") {
      process.stdout.write("Path to check: ");
      filename=fs.readSync(process.stdin.fd, 100, 0, 'utf8').shift().trim();
      process.stdin.pause();
   }
   if(filename==="") {
      process.exit(0);
   }
   if(user==="") {
      process.stdout.write("Login: ");
      user=fs.readSync(process.stdin.fd, 100, 0, 'utf8').shift().trim();
      process.stdin.pause();
   }
   if(user==="") {
      process.exit(0);
   }
   if(pass==="") {
      process.stdout.write("Password: ");
      pass=fs.readSync(process.stdin.fd, 100, 0, 'utf8').shift().trim();
      process.stdin.pause();
   }
   if(pass==="") {
      process.exit(0);
   }

   return;
}

function usage()
{
   console.log();
   console.log("FTP Check - (c) 2016 Scriptol.com");
   console.log("---------------------------------");
   console.log("Syntax:");
   console.log("  node testftp.js [Parameters]");
   console.log("Parameters:");
   console.log("  -ppassword.");
   console.log("  -llogin.");
   console.log("  -fftpadr ftp address in the form ftp.domain.tld (like ftp.scriptol.com).");
   console.log("  remotefile: a remote file to check for the date/time.");
   process.exit(0);
   return;
}


function main(argc,argv)
{
    processCommand(argc, argv.slice(1));
    OPTIONS={"host":server,"port":21,"user":user,"pass":pass,"debugMode":true};
    var connection = new JSFtp(OPTIONS);
    console.log("Checking FTP on "+ server);       
    connection.raw.stat(function(err, data) {
        if(err) {
            console.log("Server not available through FTP. Error:" + err)
            return
        }
        console.log("Server OK.")

        console.log("Checking date of " + filename);   

        connection.raw.mdtm(filename, function(err, data) {
            if(err) {
                console.log("Date not returned. Error: " + err)
                return
            }    
            console.log("Date/Time: " + data.text.substr(4))
            console.log("Data returned:")
            console.log(JSON.stringify(data))
            connection.raw.quit(function(err, data) {
                console.log("Bye!");
                process.exit(1);
            });
    
        });
    });
}    

main(process.argv.length-1,process.argv.slice(1));
        
